@extends('layout.app')

@section('meta-information')
    <title>Create Portal</title>
@endsection

@section('main-content')
<div class="bg-white p-6">
    <h2 class="text-xl font-bold mb-4">Add New Portal</h2>

    <form action="{{ route('role.portal-management.store', ['role' => Str::slug(Auth::user()->getRoleNames()->first())]) }}" method="POST">
        @csrf

        <div class="mb-3">
            <label>Name</label>
            <input type="text" name="name" required class="w-full border px-3 py-2 rounded" value="{{ old('name') }}">
        </div>

        <div class="mb-3">
            <label>API Key</label>
            <input type="text" name="api_key" class="w-full border px-3 py-2 rounded">
        </div>

        <div class="mb-3">
            <label>API Secret</label>
            <input type="text" name="api_secret" class="w-full border px-3 py-2 rounded">
        </div>

        <div class="mb-3">
            <label>Base URL</label>
            <input type="text" name="base_url" class="w-full border px-3 py-2 rounded">
        </div>

        <div class="mb-3">
            <label>Type</label>
            <select name="type" class="w-full border px-3 py-2 rounded">
                <option value="flight">Flight</option>
                <option value="bus">Bus</option>
                <option value="train">Train</option>
            </select>
        </div>

        <div class="mb-3">
            <label>Vendor</label>
            <select name="vendor_id" class="w-full border px-3 py-2 rounded">
                <option value="">-- Select Vendor --</option>
                @foreach($vendors as $vendor)
                    <option value="{{ $vendor->id }}">{{ $vendor->name }}</option>
                @endforeach
            </select>
        </div>

        <div class="mb-3">
            <label>Status</label>
            <select name="status" class="w-full border px-3 py-2 rounded">
                <option value="active">Active</option>
                <option value="inactive">Inactive</option>
            </select>
        </div>

        <div class="mt-4">
            <button class="px-4 py-2 bg-blue-600 text-white rounded cursor-pointer">Save</button>
        </div>
    </form>
</div>
@endsection
