<aside id="sidebar" class="sidebar fixed top-0 left-0 h-full w-64 z-20 transform -translate-x-full md:translate-x-0 transition-transform duration-300 ease-in-out overflow-y-auto">
    <!-- Header -->
    <div class="flex justify-between items-center p-6 border-b border-blue-500/30">
        <div class="flex items-center text-left">
            <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center mr-3">
                <i class="fas fa-chart-pie text-blue-600 text-lg"></i>
            </div>
            <div class="text-xl font-bold text-white"><?php echo e(config('app.name')); ?></div>
        </div>
        <button id="closeSidebar" class="text-white text-xl md:hidden">
            <i class="fas fa-times"></i>
        </button>
    </div>

    <!-- Navigation -->
    <nav class="p-2 space-y-2">
        <!-- Dashboard -->
        <a href="<?php echo e(route('role.dashboard', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.dashboard') ? 'active' : ''); ?>">
            <i class="fas fa-chart-line w-6 text-center mr-1"></i>
            <span>Dashboard</span>
        </a>

        <!-- branch -->
        <a href="<?php echo e(route('role.branches.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.branches.index') ? 'active' : ''); ?>">
            <i class="fas fa-code-branch w-6 text-center mr-1"></i>
            <span>Branch</span>
        </a>

        <!-- Vendor -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('vendorSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-users w-6 text-center mr-1"></i>
                    <span>Vendor</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="vendorSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.vendor.create') || request()->routeIs('role.vendor.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.vendor.create', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.vendor.create') ? 'active' : ''); ?>"><i class="fas fa-plus"></i> Add Vendor</a>
                <a href="<?php echo e(route('role.vendor.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.vendor.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Vendor</a>
            </div>
        </div>

        <!-- Users -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('userSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-user-friends w-6 text-center mr-1"></i>
                    <span>User Managements</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="userSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.user.create') || request()->routeIs('role.customers.index') || request()->routeIs('role.suppliers.index') || request()->routeIs('role.user.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.user.create', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.user.create') ? 'active' : ''); ?>"><i class="fas fa-plus"></i> Add User</a>
                <a href="<?php echo e(route('role.user.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.user.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Users</a>
                <a href="<?php echo e(route('role.customers.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.customers.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Customers</a>
                <a href="<?php echo e(route('role.suppliers.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.suppliers.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Suppliers</a>
            </div>
        </div>

        <!-- Item Management -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('itemSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-box w-6 text-center mr-1"></i>
                    <span>Product Management</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="itemSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.units.index') || request()->routeIs('role.brands.index') || request()->routeIs('role.categories.index') || request()->routeIs('role.sub-categories.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.units.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.units.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Unit</a>
                <a href="<?php echo e(route('role.brands.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.brands.create') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Brand</a>
                <a href="<?php echo e(route('role.categories.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.categories.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Category</a>
                <a href="<?php echo e(route('role.sub-categories.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.sub-categories.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Sub Category</a>
                <a href="<?php echo e(route('role.products.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.products.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Product</a>
            </div>
        </div>

        <!-- Portal Management -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('portalSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-globe w-6 text-center mr-1"></i>
                    <span>Portal Management</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="portalSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.portal-management.create') || request()->routeIs('role.portal-management.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.portal-management.create', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.portal-management.create') ? 'active' : ''); ?>"><i class="fas fa-plus"></i> Add Portal</a>
                <a href="<?php echo e(route('role.portal-management.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.portal-management.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Portal</a>
            </div>
        </div>

        <!-- Passport Category -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('passportCategory', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-passport w-6 text-center mr-1"></i>
                    <span>Passport Category</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="passportCategory" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.passport-holder-category.create') || request()->routeIs('role.passport-holder-category.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.passport-holder-category.create', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.passport-holder-category.create') ? 'active' : ''); ?>"><i class="fas fa-plus"></i> Add Category</a>
                <a href="<?php echo e(route('role.passport-holder-category.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.passport-holder-category.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Category</a>
            </div>
        </div>

        <!-- Passport Holder -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('passportSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-id-card w-6 text-center mr-1"></i>
                    <span>Passport Holder</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="passportSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.passport-holder.create') || request()->routeIs('role.passport-holder.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.passport-holder.create', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.passport-holder.create') ? 'active' : ''); ?>"><i class="fas fa-plus"></i> Add Holder</a>
                <a href="<?php echo e(route('role.passport-holder.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.passport-holder.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Holder</a>
            </div>
        </div>

        <!-- Ticket Purchase -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('purchaseSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-ticket-alt w-6 text-center mr-1"></i>
                    <span>Ticket Purchase</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="purchaseSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.ticket-purchase.create') || request()->routeIs('role.ticket-purchase.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.ticket-purchase.create', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.ticket-purchase.create') ? 'active' : ''); ?>"><i class="fas fa-plus"></i> Add Purchase</a>
                <a href="<?php echo e(route('role.ticket-purchase.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.ticket-purchase.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Purchase</a>
            </div>
        </div>

        <!-- Ticket Sales -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('ticketSell', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-receipt w-6 text-center mr-1"></i>
                    <span>Ticket Sales</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="ticketSell" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.ticket-sales.create') || request()->routeIs('role.ticket-sales.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.ticket-sales.create', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.ticket-sales.create') ? 'active' : ''); ?>"><i class="fas fa-plus"></i> Add Sales</a>
                <a href="<?php echo e(route('role.ticket-sales.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.ticket-sales.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Sales</a>
            </div>
        </div>

        <!-- Inventory -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('inventorySubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-boxes-stacked w-6 text-center mr-1"></i>
                    <span>Inventory</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="inventorySubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.return-refs.index') ||
                request()->routeIs('role.return-refs.create') ||
                request()->routeIs('role.return-refs.edit') ||
                request()->routeIs('role.stock-transfers.index') ||
                request()->routeIs('role.stock-transfers.create') ||
                request()->routeIs('role.stock-transfers.edit') ||
                request()->routeIs('role.stock-movements.index') ||
                request()->routeIs('role.stock-movements.create') ||
                request()->routeIs('role.stock-movements.edit') ||
                request()->routeIs('role.sales.index') ||
                request()->routeIs('role.sales.create') ||
                request()->routeIs('role.sales.edit') ||
                request()->routeIs('role.purchases.index') ||
                request()->routeIs('role.purchases.create') ||
                request()->routeIs('role.purchases.edit')
                ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.sales.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.sales.index') || request()->routeIs('role.sales.create') || request()->routeIs('role.sales.edit') ? 'active' : ''); ?>"><i class="fas fa-chart-pie"></i> Sale</a>
                <a href="<?php echo e(route('role.purchases.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.purchases.index') || request()->routeIs('role.purchases.create') || request()->routeIs('role.purchases.edit') ? 'active' : ''); ?>"><i class="fas fa-dollar"></i> Purchase</a>
                <a href="<?php echo e(route('role.stock-transfers.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.stock-transfers.index') || request()->routeIs('role.stock-transfers.create') || request()->routeIs('role.stock-transfers.edit') ? 'active' : ''); ?>"><i class="fas fa-exchange"></i> Stock Transfer</a>
                <a href="<?php echo e(route('role.stock-movements.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.stock-movements.index') || request()->routeIs('role.stock-movements.create') || request()->routeIs('role.stock-movements.edit') ? 'active' : ''); ?>"><i class="fas fa-warehouse"></i> Stock Adjustment</a>
                <a href="<?php echo e(route('role.return-refs.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.return-refs.index') || request()->routeIs('role.return-refs.create') || request()->routeIs('role.return-refs.edit') ? 'active' : ''); ?>"><i class="fas fa-undo"></i> Return Reference</a>
            </div>
        </div>

        <!-- Geography Info -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('regionalSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-map-marker-alt w-6 text-center mr-1"></i>
                    <span>Geography Info</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="regionalSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.user.create') || request()->routeIs('role.user.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.countries.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.countries.index') ? 'active' : ''); ?>"><i class="fas fa-flag"></i> Country</a>
                <a href="<?php echo e(route('role.states.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.states.index') ? 'active' : ''); ?>"><i class="fas fa-city"></i> States</a>
                <a href="<?php echo e(route('role.airport.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.airport.index') ? 'active' : ''); ?>"><i class="fas fa-plane-departure"></i> Airport Management</a>
            </div>
        </div>

        <!-- Expenses -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('expensesSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-money-bill-wave w-6 text-center mr-1"></i>
                    <span>Expenses</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="expensesSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.expense-subcategories.index') || request()->routeIs('role.expense-categories.index') || request()->routeIs('role.expenses.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.expense-categories.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.expense-categories.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-folder"></i> Expense Category
                </a>
                <a href="<?php echo e(route('role.expense-subcategories.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.expense-subcategories.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-folder"></i> Sub Category
                </a>
                <a href="<?php echo e(route('role.expenses.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.expenses.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-list"></i> All Expenses
                </a>
            </div>
        </div>

        <!-- HRM -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('hrmSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-users w-6 text-center mr-1"></i>
                    <span>HRM</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="hrmSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm
                <?php echo e(request()->routeIs('role.departments.index') ||
                    request()->routeIs('role.designations.index') ||
                    request()->routeIs('role.holidays.index') ||
                    request()->routeIs('role.shifts.index') ||
                    request()->routeIs('role.leaves.index') ||
                    request()->routeIs('role.attendances.index') ||
                    request()->routeIs('role.leave-types.index') ||
                    request()->routeIs('role.attendence-settings.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.departments.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.departments.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-building"></i> Department
                </a>
                <a href="<?php echo e(route('role.designations.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.designations.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-building"></i> Designation
                </a>
                <a href="<?php echo e(route('role.attendence-settings.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.attendence-settings.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> Attendance Settings
                </a>
                <a href="<?php echo e(route('role.shifts.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.shifts.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> Shift
                </a>
                <a href="<?php echo e(route('role.holidays.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.holidays.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> Holidays
                </a>
                <a href="<?php echo e(route('role.leave-types.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.leave-types.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> Leave Types
                </a>
                <a href="<?php echo e(route('role.leaves.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.leaves.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> All Leaves
                </a>
                <a href="<?php echo e(route('role.attendances.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.attendances.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> All Attendances
                </a>
            </div>
        </div>

        <!-- Payroll -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('payrollSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-money-check-alt w-6 text-center mr-1"></i>
                    <span>Payroll</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="payrollSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm
                <?php echo e(request()->routeIs('role.salary-templates.index') ||
                    request()->routeIs('role.departments.index') ||
                    request()->routeIs('role.salary-templates.index') ||
                    request()->routeIs('role.sales-records.index') ||
                    request()->routeIs('role.employee-salaries.index') ||
                    request()->routeIs('role.loans.index') ||
                    request()->routeIs('role.payments.index') ||
                    request()->routeIs('role.payslips.index') ||
                    request()->routeIs('role.advance-salaries.index') ||
                    request()->routeIs('role.commissions.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.salary-templates.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.salary-templates.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-file-invoice-dollar"></i> Salary Template
                </a>
                
                <a href="<?php echo e(route('role.employee-salaries.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.employee-salaries.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-list"></i> Salary Manage
                </a>
                <a href="<?php echo e(route('role.loans.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.loans.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-hand-holding-dollar"></i> Loan Management
                </a>
                
                <a href="<?php echo e(route('role.payslips.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.payslips.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-file-lines"></i> Payslip
                </a>
                <a href="<?php echo e(route('role.advance-salaries.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.advance-salaries.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-sack-dollar"></i> Advance Salary
                </a>
                <a href="<?php echo e(route('role.commissions.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.commissions.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-percent"></i> Commission
                </a>
            </div>
        </div>

        <!-- Bank -->
        <a href="<?php echo e(route('role.banks.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.banks.index') ? 'active' : ''); ?>">
            <i class="fas fa-building-columns w-6 text-center mr-1"></i>
            <span>Bank</span>
        </a>

        <!-- Marketing Section -->
        <div class="pt-4 mt-4 border-t border-blue-500/30">
            <h3 class="text-xs uppercase text-blue-300 font-semibold px-3 mb-2">Marketing</h3>

            <!-- Email Marketing -->
            <a href="<?php echo e(route('role.email-marketing.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.email-marketing.index') ? 'active' : ''); ?>">
                <i class="fas fa-envelope w-6 text-center mr-1"></i>
                <span>Email Marketing</span>
            </a>

            <!-- SMS Marketing -->
            <a href="<?php echo e(route('role.sms-marketing.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.sms-marketing.index') ? 'active' : ''); ?>">
                <i class="fas fa-sms w-6 text-center mr-1"></i>
                <span>SMS Marketing</span>
            </a>

            <!-- WhatsApp Marketing -->
            <a href="<?php echo e(route('role.whatsapp-marketing.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.whatsapp-marketing.index') ? 'active' : ''); ?>">
                <i class="fab fa-whatsapp w-6 text-center mr-1"></i>
                <span>WhatsApp Marketing</span>
            </a>
        </div>

        <!-- Settings -->
        <div class="pt-4 mt-4 border-t border-blue-500/30">
            <h3 class="text-xs uppercase text-blue-300 font-semibold px-3 mb-2">Settings</h3>

            <a href="<?php echo e(route('role.company-settings.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.company-settings.index') ? 'active' : ''); ?>">
                <i class="fas fa-cog w-6 text-center mr-1"></i>
                <span>Company Settings</span>
            </a>
        </div>

    </nav>
</aside>
<?php /**PATH /home/freebirds/erp.freebirdsit.com/resources/views/layout/sidebar.blade.php ENDPATH**/ ?>