<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Attendance;
use App\Models\User;
use Rats\Zkteco\Lib\ZKTeco;

class AttendanceController extends Controller
{
    public function syncAttendance(){
        if (!function_exists("socket_create")) {
            return response()->json(['status' => 'error', 'message' => 'Sockets extension not enabled']);
        }

        $zk = new ZKTeco('192.168.10.211');

        if (!$zk->connect()) {
            return response()->json([
                'status' => 'error',
                'message' => 'Unable to connect to ZKTeco device'
            ]);
        }

        $logs = $zk->getAttendance();
        
        $today = date('Y-m-d');

        foreach ($logs as $log) {

            // Only today's logs
            if (!isset($log['timestamp']) || strpos($log['timestamp'], $today) !== 0) {
                continue;
            }

            $deviceUserId = $log['id'];
            $punchTime = $log['timestamp'];

            // Map to actual user
            $user = User::where('device_user_id', $deviceUserId)->first();

            if (!$user) {
                continue; // unknown user
            }

            // Check if row exists for today
            $attendance = Attendance::where('user_id', $user->id)
                ->where('date', $today)
                ->first();
                
            if (!$attendance) {
                // Create row with check_in
                Attendance::create([
                    'user_id' => $user->id,
                    'shift_id' => $user->shift_id,
                    'attendence_setting_id' => $user->attendence_setting_id,
                    'company_id' => $user->company_id,
                    'date' => $today,
                    'check_in' => date('H:i:s', strtotime($punchTime)),
                    'status' => 'present',
                ]);
            } else {
                // Update check_out
                $attendance->update([
                    'check_out' => date('H:i:s', strtotime($punchTime)),
                ]);
            }
        }

        return response()->json([
            'status' => 'success',
            'message' => 'Today attendance synced successfully'
        ]);
    }
}
