@extends('layout.app')

@section('meta-information')
    <title>Portal List</title>
@endsection

@section('main-content')
<div class="bg-white p-6">
    <div class="flex justify-between mb-4">
        <h2 class="text-xl font-bold">All Portals</h2>
        <a href="{{ route('role.portal-management.create', ['role' => Str::slug(Auth::user()->getRoleNames()->first())]) }}" class="px-4 py-2 bg-blue-600 text-white rounded hover:bg-blue-700">Add Portal</a>
    </div>

    {{-- Success Message --}}
    @if(session('success'))
        <div class="mb-4 p-3 bg-green-100 text-green-700 rounded">
            {{ session('success') }}
        </div>
    @endif

    <table class="min-w-full table-auto border border-gray-300 text-sm">
        <thead class="bg-gray-100">
            <tr>
                <th class="border px-4 py-2">#</th>
                <th class="border px-4 py-2">Name</th>
                <th class="border px-4 py-2">Type</th>
                <th class="border px-4 py-2">Vendor</th>
                <th class="border px-4 py-2">Status</th>
                <th class="border px-4 py-2">Actions</th>
            </tr>
        </thead>
        <tbody>
            @forelse($portals as $portal)
                <tr>
                    <td class="border px-4 py-2">{{ $loop->iteration + ($portals->currentPage() - 1) * $portals->perPage() }}</td>
                    <td class="border px-4 py-2">{{ $portal->name }}</td>
                    <td class="border px-4 py-2 capitalize">{{ $portal->type }}</td>
                    <td class="border px-4 py-2">{{ $portal->vendor->name ?? 'N/A' }}</td>
                    <td class="border px-4 py-2 capitalize">{{ $portal->status }}</td>
                    <td class="border px-4 py-2 space-x-2">
                        <a href="{{ route('role.portal-management.edit', ['role' => Str::slug(Auth::user()->getRoleNames()->first()), 'portal_management'=> $portal->id]) }}" class="text-blue-600 hover:underline">Edit</a>
                        {{-- <form action="{{ route('role.portal-management.destroy', $portal->id) }}" method="POST" class="inline-block"
                              onsubmit="return confirm('Are you sure you want to delete this portal?');">
                            @csrf
                            @method('DELETE')
                            <button type="submit" class="text-red-600 hover:underline">Delete</button>
                        </form> --}}
                    </td>
                </tr>
            @empty
                <tr>
                    <td colspan="6" class="border px-4 py-2 text-center">No portals found.</td>
                </tr>
            @endforelse
        </tbody>
    </table>

    <div class="mt-4">
        {{ $portals->links() }}
    </div>
</div>
@endsection
