<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Attendance;
use App\Models\User;
use Log;
use Symfony\Component\HttpFoundation\Request;

class AttendanceController extends Controller
{
    public function serverStatus()
    {
        try {
            $status = 'Ok';
            \Log::info($status);
            return response()->json(['status' => $status]);
        } catch (\Exception $err) {
            return response()->json(['error' => $err->getMessage()], 500);
        }
    }

    public function device($data)
    {
        // try {
        \Log::info($data);
        return response()->json(['data' => $data]);
        // } catch (\Exception $err) {
        //     return response()->json(['error' => $err->getMessage()], 500);
        // }
    }

public function attendanceLog($data)
{
    try {
        \Log::info("RAW PAYLOAD: " . $data);

        // Convert raw JSON string to array
        $payload = json_decode($data, true);

        if (!$payload) {
            return response()->json(['error' => 'Invalid JSON'], 400);
        }

        foreach ($payload['logs'] as $log) {

            $userId = $log['enrollid'];
            $date = date('Y-m-d', strtotime($log['time']));
            $time = date('H:i:s', strtotime($log['time']));
            $user = User::where('device_user_id', $userId)->first();
            if (!$user) {
                \Log::warning("User with device_user_id {$userId} not found.");
                continue; // Skip to next log
            }
            $attendance = Attendance::where('user_id', $user->id)
                ->where('date', $date)
                ->first();

            if (!$attendance) {

                // first punch → check-in
                Attendance::create([
                    'user_id' => $user->id,
                    'shift_id' => $user->shift_id,
                    'employee_id' => $userId,
                    'attendence_setting_id' => 1,
                    'company_id' => $user->company_id,
                    'date' => $date,
                    'check_in' => $time,
                    'status' => 'present',
                    'note' => 'Auto punch from device'
                ]);

            } else {

                // second punch → check-out
                $attendance->update([
                    'check_out' => $time
                ]);
            }
        }

        return response()->json(['message' => 'Attendance saved'], 200);

    } catch (\Exception $e) {
        \Log::error($e->getMessage());
        return response()->json(['error' => $e->getMessage()], 500);
    }
}



}
