<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Commission extends Model
{
    use HasFactory;

    protected $table = 'commissions';

    protected $fillable = [
        'user_id',    
        'sales_record_id',    
        'amount',    
        'month',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function sale_record()
    {
        return $this->belongsTo(SaleRecord::class);
    }
}
