<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('ticket_legs', function (Blueprint $table) {
            $table->id();
            $table->foreignId('ticket_purchase_id')->constrained('ticket_purchases')->onDelete('cascade');
            $table->string('from_location')->nullable();
            $table->string('to_location')->nullable();
            $table->date('travel_date')->nullable();
            $table->string('seat_number')->nullable();
            $table->string('attachment')->nullable(); // store path of file
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('ticket_legs');
    }
};
