<div id="editModal" class="modal fixed inset-0 flex items-center justify-center z-50 hidden">
    <div class="modal-backdrop fixed inset-0 bg-black opacity-50"></div>
    <div class="modal-container bg-white w-11/12 md:max-w-md mx-auto rounded shadow-lg z-50 overflow-y-auto" style="min-width: 1000px">
        <div class="modal-content py-4 text-left px-6">
            <div class="modal-header flex justify-between items-center pb-3">
                <h3 class="text-xl font-semibold">Edit </h3>
                <button class="modal-close-edit z-50">
                    <i class="fas fa-times"></i>
                </button>
            </div>
            <div class="modal-body">
                <form id="editForm" method="POST" enctype="multipart/form-data"
                    action="{{ route('role.banks.update', ['role' => Str::slug(Auth::user()->getRoleNames()->first()), 'bank' => 1]) }}">
                    @csrf
                    @method('PUT')
                    <input type="hidden" id="editItemId" name="id">                    
                    <div class="grid grid-cols-1 md:grid-cols-3 gap-4">          
                        <div class="mb-4">
                            <label for="edit_name" class="block text-gray-700 text-sm font-bold mb-2">Name</label>
                            <input type="text" id="edit_name" name="name" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter Name">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter a Name</p>
                        </div>                                      
                        <div class="mb-4">
                            <label for="edit_branch_name" class="block text-gray-700 text-sm font-bold mb-2">Branch Name</label>
                            <input type="text" id="edit_branch_name" name="branch_name" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter branch name">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter your branch name</p>
                        </div>                          
                        <div class="mb-4">
                            <label for="edit_account_name" class="block text-gray-700 text-sm font-bold mb-2">Account Name</label>
                            <input type="text" id="edit_account_name" name="account_name" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter account name">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter your account name</p>
                        </div>  
                        <div class="mb-4">
                            <label for="edit_account_type" class="block text-gray-700 text-sm font-bold mb-2">Account Type *</label>
                            <select id="edit_account_type" name="account_type" class="form-select w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 select2" style="width: 100%" required>
                                <option value="">-- Select Type --</option>
                                <option value="savings" {{ old('account_type') == 'savings' ? 'selected' : '' }}>Savings</option>
                                <option value="current" {{ old('account_type') == 'current' ? 'selected' : '' }}>Current</option>
                                <option value="fixed" {{ old('account_type') == 'fixed' ? 'selected' : '' }}>Fixed</option>
                            </select>
                        </div>                
                        <div class="mb-4">
                            <label for="edit_bank_type" class="block text-gray-700 text-sm font-bold mb-2">Bank Type *</label>
                            <select id="edit_bank_type" name="bank_type" class="form-select w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 select2" style="width: 100%" required>
                                <option value="">-- Select Type --</option>
                                <option value="national" {{ old('bank_type') == 'national' ? 'selected' : '' }}>National</option>
                                <option value="international" {{ old('bank_type') == 'international' ? 'selected' : '' }}>International</option>
                            </select>
                        </div>                
                        <div class="mb-4">
                            <label for="edit_type" class="block text-gray-700 text-sm font-bold mb-2">Payment Type *</label>
                            <select id="edit_type" name="type" class="form-select w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500 select2" style="width: 100%" required>
                                <option value="">-- Select Type --</option>
                                <option value="bank" {{ old('type') == 'bank' ? 'selected' : '' }}>Bank</option>
                                <option value="mobile_banking" {{ old('type') == 'mobile_banking' ? 'selected' : '' }}>Mobile Banking</option>
                                <option value="digital_wallet" {{ old('type') == 'digital_wallet' ? 'selected' : '' }}>Digital Wallet</option>
                            </select>
                        </div>                       
                        <div class="mb-4">
                            <label for="edit_routing_number" class="block text-gray-700 text-sm font-bold mb-2">Routing Number</label>
                            <input type="text" id="edit_routing_number" name="routing_number" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter Routing Number">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter your Routing Number</p>
                        </div>                          
                        <div class="mb-4">
                            <label for="edit_account_number" class="block text-gray-700 text-sm font-bold mb-2">Account number</label>
                            <input type="text" id="edit_account_number" name="account_number" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter Account number">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter your Account number</p>
                        </div>                          
                        <div class="mb-4">
                            <label for="edit_iban" class="block text-gray-700 text-sm font-bold mb-2">Iban</label>
                            <input type="text" id="edit_iban" name="iban" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter iban">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter your iban</p>
                        </div>                          
                        <div class="mb-4">
                            <label for="edit_swift_code" class="block text-gray-700 text-sm font-bold mb-2">Swift code</label>
                            <input type="text" id="edit_swift_code" name="swift_code" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter swift code">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter your swift code</p>
                        </div>                          
                        <div class="mb-4">
                            <label for="edit_currency" class="block text-gray-700 text-sm font-bold mb-2">Currency</label>
                            <input type="text" id="edit_currency" name="currency" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter currency">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter your currency</p>
                        </div>                          
                        <div class="mb-4">
                            <label for="edit_address" class="block text-gray-700 text-sm font-bold mb-2">Address</label>
                            <input type="text" id="edit_address" name="address" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter address">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter your address</p>
                        </div>                          
                        <div class="mb-4">
                            <label for="edit_balance" class="block text-gray-700 text-sm font-bold mb-2">Initial Balance</label>
                            <input type="text" id="edit_balance" name="balance" class="form-input w-full px-3 py-2 border border-gray-300 rounded-md focus:outline-none focus:ring-2 focus:ring-blue-500" placeholder="Enter enter an amount">
                            <p class="text-red-500 text-xs mt-1 hidden error-message">Please enter an amount</p>
                        </div>  
                        <div class="mb-4">
                            <label class="flex items-center">
                                <input type="checkbox" name="status" id="edit_status" class="form-checkbox h-5 w-5 text-blue-600" checked>
                                <span class="ml-2 text-gray-700">Active</span>
                            </label>
                        </div>
                    </div>
                </form>
            </div>
            <div class="modal-footer flex justify-end pt-2">
                <button type="button" class="btn btn-secondary px-4 py-2 bg-gray-300 text-gray-700 rounded-md hover:bg-gray-400 transition duration-200 mr-2 modal-close-edit">
                    Cancel
                </button>
                <button data-action="{{ route('role.banks.update', ['role' => Str::slug(Auth::user()->getRoleNames()->first()), 'bank' => 1]) }}" id="editSubmit" type="button" class="btn btn-primary px-4 py-2 bg-blue-500 text-white rounded-md hover:bg-blue-600 transition duration-200">
                    Update
                </button>
            </div>
        </div>
    </div>
</div>
