<!DOCTYPE html>
<html>
<head>
    <title>Attendance Report</title>
    <style>
        body { font-family: sans-serif; font-size: 12px; color: #333; }
        .header { text-align: center; margin-bottom: 30px; border-bottom: 2px solid #444; padding-bottom: 10px; }
        .company-name { font-size: 20px; font-weight: bold; text-transform: uppercase; }
        .user-info { margin-bottom: 20px; }
        table { width: 100%; border-collapse: collapse; margin-bottom: 20px; }
        th { background-color: #f2f2f2; font-weight: bold; }
        th, td { border: 1px solid #ddd; padding: 8px; text-align: left; }
        .status-late { color: orange; font-weight: bold; }
        .status-absent { color: red; }
        .status-present { color: green; }
        .summary-box { margin-top: 30px; width: 300px; float: right; }
        .summary-item { padding: 5px 0; border-bottom: 1px solid #eee; }
        .summary-item strong { float: right; }
        .clear { clear: both; }
    </style>
</head>
<body>

    <div class="header">
        <div class="company-name">{{ $user->company?->name }}</div>
        <div>Monthly Attendance Report: {{ $month }} {{ $year }}</div>
    </div>

    <div class="user-info">
        <strong>Employee:</strong> {{ $user->name }}<br>
        <strong>Email:</strong> {{ $user->email }}<br>
        <strong>Phone:</strong> {{ $user->phone ?? 'N/A' }}
    </div>
    @php
        $total_minutes = 0;
    @endphp
    <table>
        <thead>
            <tr>
                <th>Date</th>
                <th>Day</th>
                <th>Shift</th>
                <th>Check In</th>
                <th>Check Out</th>
                <th>Worked Hour</th>
                <th>Status</th>
            </tr>
        </thead>
        <tbody>
            @foreach($attendances as $row)
            @php
                $worked_display = "--"; 
                $dt = \Carbon\Carbon::parse($row->date);
                if ($row->check_in && $row->check_out) {
                    $start = \Carbon\Carbon::parse($row->check_in);
                    $end = \Carbon\Carbon::parse($row->check_out);

                    // Handle overnight shifts
                    if ($end->lt($start)) {
                        $end->addDay();
                    }

                    // Calculate total minutes for this row
                    $diffInMinutes = $start->diffInMinutes($end);
                    $total_minutes += $diffInMinutes;

                    // Format row display: "8h 30m"
                    $h = floor($diffInMinutes / 60);
                    $m = $diffInMinutes % 60;
                    $worked_display = "{$h}h {$m}m";
                    
                } elseif ($row->check_in && !$row->check_out) {
                    $worked_display = "Missing Out";
                }
            @endphp 
            <tr>
                <td>{{ $dt->format('d-M-Y') }}</td>
                <td>{{ $dt->format('l') }}</td>
                <td>{{ $row->shift_name }}</td>
                <td>{{ $row->check_in ? \Carbon\Carbon::parse($row->check_in)->format('h:i A') : '--' }}</td>
                <td>{{ $row->check_out ? \Carbon\Carbon::parse($row->check_out)->format('h:i A') : '--' }}</td>
                <td>{{ $worked_display }}</td>
                <td class="status-{{ strtolower($row->status) }}">{{ ucfirst($row->status) }}</td>
            </tr>
            @endforeach
        </tbody>
    </table>
    @php
        $total_h = floor($total_minutes / 60);
        $total_m = $total_minutes % 60;
    @endphp  
    <div class="summary-box">
        <h3>Summary</h3>
        <div class="summary-item">Total Present: <strong>{{ $summary->present }}</strong></div>
        <div class="summary-item">Total Late: <strong>{{ $summary->late }}</strong></div>
        <div class="summary-item">Total Worked Hours: <strong>{{ "{$total_h}H {$total_m}M" }}</strong></div>
        <div class="summary-item">Total Absent: <strong>{{ $summary->absent }}</strong></div>
        <div class="summary-item">Total Holiday: <strong>{{ $summary->holiday }}</strong></div>
        <div class="summary-item" style="border-bottom: 2px solid #333;">Total Leave: <strong>{{ $summary->leave }}</strong></div>
    </div>

    <div class="clear"></div>

</body>
</html>