<?php

use App\Http\Controllers\LeaveController;
use App\Http\Controllers\AirportController;
use App\Http\Controllers\HolidayController;
use App\Http\Controllers\AttendanceController;
use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\Auth;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\CompanyController;
use App\Http\Controllers\Dashboard\BankController;
use App\Http\Controllers\CountryController;
use App\Http\Controllers\Dashboard\DashboardController;
use App\Http\Controllers\Dashboard\UserController;
use App\Http\Controllers\Dashboard\PassportHolderController;
use App\Http\Controllers\Dashboard\VendorController;
use App\Http\Controllers\Dashboard\PortalManagementController;
use App\Http\Controllers\Dashboard\PayrolController;
use App\Http\Controllers\Dashboard\RouteManagementController;
use App\Http\Controllers\Dashboard\TicketPurchaseController;
use App\Http\Controllers\Dashboard\TicketSellController;
use App\Http\Controllers\Dashboard\SmsMarketingController;
use App\Http\Controllers\Dashboard\EmailMarketingController;
use App\Http\Controllers\Dashboard\WhatsappMarketingController;
use App\Http\Controllers\Dashboard\PassportHolderCategoryController;
use App\Http\Controllers\StateController;
use App\Http\Controllers\Dashboard\TicketSaleController;
use App\Http\Controllers\DepartmentController;
use App\Http\Controllers\SalaryTemplateController;
use App\Http\Controllers\SaleRecordController;
use App\Http\Controllers\EmployeeSalaryController;
use App\Http\Controllers\LoanController;
use App\Http\Controllers\PaymentController;
use App\Http\Controllers\PayslipController;
use App\Http\Controllers\AdvanceSalaryController;
use App\Http\Controllers\Api\AttendanceController as ApiAttendanceController;
use App\Http\Controllers\ApiController;
use App\Http\Controllers\AttendanceSettingController;
use App\Http\Controllers\BranchController;
use App\Http\Controllers\BrandController;
use App\Http\Controllers\CategoryController;
use App\Http\Controllers\CommissionController;
use App\Http\Controllers\CustomerController;
use App\Http\Controllers\Dashboard\BankControllerV2;
use App\Http\Controllers\Dashboard\PassportHolderControllerV2;
use App\Http\Controllers\Dashboard\PassportHolderCategoryControllerV2;
use App\Http\Controllers\DesignationController;
use App\Http\Controllers\ExpenseCategoryController;
use App\Http\Controllers\ExpenseController;
use App\Http\Controllers\ExpenseSubCategoryController;
use App\Http\Controllers\LeaveTypeController;
use App\Http\Controllers\ProductController;
use App\Http\Controllers\PurchaseController;
use App\Http\Controllers\Report\ReportController;
use App\Http\Controllers\SaleController;
use App\Http\Controllers\SaleReturnController;
use App\Http\Controllers\ShiftController;
use App\Http\Controllers\SmsTemplateController;
use App\Http\Controllers\StockMovementController;
use App\Http\Controllers\StockTransferController;
use App\Http\Controllers\SubCategoryController;
use App\Http\Controllers\SupplierController;
use App\Http\Controllers\UnitController;

Route::get('/', function () {
     return Auth::check()
        ? redirectToRoleDashboard(Auth::user())
        : redirect()->route('login');
});


Route::get('server_status', [ApiController::class, 'serverStatus']);
Route::get('device/{data}', [ApiController::class, 'device']);
Route::get('attendance_log', [ApiController::class, 'attendanceLog']);

// Login routes
Route::get('/login', [LoginController::class, 'showLoginForm'])->name('login');
Route::post('/login', [LoginController::class, 'login']);
Route::post('/logout', [LoginController::class, 'logout'])->name('logout');

Route::get('server_status', [ApiAttendanceController::class, 'serverStatus']);
Route::get('device/{data}', [ApiAttendanceController::class, 'device']);
Route::get('attendance_log/{data}', [ApiAttendanceController::class, 'attendanceLog']);

// Super Admin routes
Route::middleware(['auth', 'role:super admin|admin|vendor|agent']) // or a custom role middleware
->prefix('{role}')
->name('role.')
->group(function () {
    Route::get('/dashboard', [DashboardController::class, 'index'])->name('dashboard');
    Route::post('change-password', [LoginController::class, 'updatePassword'])->name('change.password');
    Route::resource('user', UserController::class);
    Route::resource('passport-holder', PassportHolderControllerV2::class);
    Route::resource('passport-holder-category', PassportHolderCategoryControllerV2::class);
    Route::resource('vendor', VendorController::class);
    Route::put('vendor/logs/{log}/restore', [VendorController::class, 'restore'])->name('vendor.restore');
    Route::put('vendor/{id}/toggle-status', [VendorController::class, 'toggleStatus'])->name('vendor.toggleStatus');
    Route::resource('portal-management', PortalManagementController::class);
    Route::resource('banks', BankControllerV2::class);
    Route::resource('payrol', PayrolController::class);
    Route::resource('route', RouteManagementController::class);
    Route::resource('ticket-purchase', TicketPurchaseController::class);
    Route::resource('ticket-sales', TicketSaleController::class);
    Route::resource('sms-marketing', SmsMarketingController::class);
    Route::resource('email-marketing', EmailMarketingController::class);
    Route::resource('whatsapp-marketing', WhatsappMarketingController::class);
    Route::resource('countries', CountryController::class)->except('show');
    Route::resource('states', StateController::class)->except('show');
    Route::resource('airport', AirportController::class)->except('show');
    Route::get('get-states-by-country', [StateController::class, 'getStatesByCountry'])->name('get-states-by-country');
    Route::resource('company-settings', CompanyController::class)->except('show');
    Route::resource('sms_templates', SmsTemplateController::class)->except('show');
    Route::resource('departments', DepartmentController::class)->except('show');
    Route::resource('designations', DesignationController::class)->except('show');
    Route::resource('shifts', ShiftController::class)->except('show');
    Route::resource('holidays', HolidayController::class)->except('show');
    Route::resource('attendances', AttendanceController::class)->except('show');
    Route::resource('leaves', LeaveController::class)->except('show');
    Route::resource('leave-types', LeaveTypeController::class)->except('show');
    Route::resource('attendence-settings', AttendanceSettingController::class)->except('show');
    Route::resource('salary-templates', SalaryTemplateController::class)->except('show');
    Route::resource('sales-records', SaleRecordController::class)->except('show');
    Route::resource('employee-salaries', EmployeeSalaryController::class)->except('show');
    Route::get('get-employee-salary', [EmployeeSalaryController::class, 'getEmployeeSalary'])->name('get-employee-salary');
    Route::resource('loans', LoanController::class)->except('show');
    Route::resource('payments', PaymentController::class)->except('show');
    Route::resource('payslips', PayslipController::class)->except('show');
    Route::resource('advance-salaries', AdvanceSalaryController::class)->except('show');
    Route::resource('commissions', CommissionController::class)->except('show');
    Route::resource('expense-categories', ExpenseCategoryController::class)->except('show');
    Route::resource('expense-subcategories', ExpenseSubCategoryController::class)->except('show');
    Route::get('get-expense-sub-category', [ExpenseSubCategoryController::class, 'getExpenseSubCategory'])->name('get-expense-sub-category');
    Route::resource('expenses', ExpenseController::class)->except('show');
    Route::resource('units', UnitController::class)->except('show');
    Route::resource('brands', BrandController::class)->except('show');
    Route::resource('categories', CategoryController::class)->except('show');
    Route::resource('sub-categories', SubCategoryController::class)->except('show');
    Route::get('get-sub-category', [SubCategoryController::class, 'getSubCategory'])->name('get-sub-category');
    Route::resource('branches', BranchController::class)->except('show');
    Route::resource('customers', CustomerController::class)->except('show');
    Route::resource('suppliers', SupplierController::class)->except('show');
    Route::resource('products', ProductController::class)->except('show');
    Route::get('get-product-edit-modal', [ProductController::class, 'getProductEditModal'])->name('get-product-edit-modal');
    Route::resource('sales', SaleController::class)->except('show');
    Route::resource('purchases', PurchaseController::class)->except('show');
    Route::resource('stock-transfers', StockTransferController::class)->except('show');
    Route::resource('stock-movements', StockMovementController::class)->except('show');
    Route::resource('return-refs', SaleReturnController::class)->except('show');

    Route::prefix('report')->name('report.')->group(function () {
        Route::get('/monthly-attendances', [ReportController::class, 'monthly_attendances'])->name('monthly-attendances');
    });
});

Route::prefix('export')->name('export.')->group(function () {
    Route::get('monthly/attendance/excel', [ReportController::class, 'monthlyAttendanceExcel'])->name('monthly.attendance.excel');
    Route::get('monthly/attendance/pdf', [ReportController::class, 'monthlyAttendancePdf'])->name('monthly.attendance.pdf');
});

//attendance
Route::get('attendance/sync', [ApiAttendanceController::class, 'syncAttendance']);

// Function to redirect user to their respective dashboard based on role

// function redirectToRoleDashboard($user)
// {
//     if ($user->hasRole('super admin')) {
//         return redirect()->route('role.dashboard', ['role' => 'super-admin']);
//     } elseif ($user->hasRole('admin')) {
//         return redirect()->route('role.dashboard', ['role' => 'admin']);
//     } elseif ($user->hasRole('vendor')) {
//         return redirect()->route('role.dashboard', ['role' => 'vendor']);
//     } elseif ($user->hasRole('agent')) {
//         return redirect()->route('role.dashboard', ['role' => 'agent']);
//     } else {
//         return redirect()->route('login');
//     }
// }
