<aside id="sidebar" class="sidebar fixed top-0 left-0 h-full w-64 z-20 transform -translate-x-full md:translate-x-0 transition-transform duration-300 ease-in-out overflow-y-auto">
    <!-- Header -->
    <div class="flex justify-between items-center p-6 border-b border-blue-500/30">
        <div class="flex items-center text-left">
            <div class="w-10 h-10 bg-white rounded-lg flex items-center justify-center mr-3">
                <i class="fas fa-chart-pie text-blue-600 text-lg"></i>
            </div>
            <div class="text-xl font-bold text-white"><?php echo e(config('app.name')); ?></div>
        </div>
        <button id="closeSidebar" class="text-white text-xl md:hidden">
            <i class="fas fa-times"></i>
        </button>
    </div>

    <!-- Navigation -->
    <nav class="p-2 space-y-2">
        <!-- Dashboard -->
        <a href="<?php echo e(route('role.dashboard', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.dashboard') ? 'active' : ''); ?>">
            <i class="fas fa-chart-line w-6 text-center mr-1"></i>
            <span>Dashboard</span>
        </a>

        <!-- branch -->
        

        <!-- Vendor -->
        

        <!-- Users -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('userSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-user-friends w-6 text-center mr-1"></i>
                    <span>User Managements</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="userSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.user.create') || request()->routeIs('role.customers.index') || request()->routeIs('role.suppliers.index') || request()->routeIs('role.user.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.user.create', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.user.create') ? 'active' : ''); ?>"><i class="fas fa-plus"></i> Add User</a>
                <a href="<?php echo e(route('role.user.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.user.index') ? 'active' : ''); ?>"><i class="fas fa-list"></i> Manage Users</a>
                
            </div>
        </div>

        <!-- Item Management -->
        

        <!-- Portal Management -->
        

        <!-- Passport Category -->
        

        <!-- Ticket Purchase -->
        

        <!-- Ticket Sales -->
        

        <!-- Inventory -->
        

        <!-- Geography Info -->
        

        <!-- Expenses -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('expensesSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-money-bill-wave w-6 text-center mr-1"></i>
                    <span>Expenses</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="expensesSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.expense-subcategories.index') || request()->routeIs('role.expense-categories.index') || request()->routeIs('role.expenses.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.expense-categories.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.expense-categories.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-folder"></i> Expense Category
                </a>
                <a href="<?php echo e(route('role.expense-subcategories.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.expense-subcategories.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-folder"></i> Sub Category
                </a>
                <a href="<?php echo e(route('role.expenses.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.expenses.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-list"></i> All Expenses
                </a>
            </div>
        </div>

        <!-- HRM -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('hrmSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-users w-6 text-center mr-1"></i>
                    <span>HRM</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="hrmSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm
                <?php echo e(request()->routeIs('role.departments.index') ||
                    request()->routeIs('role.designations.index') ||
                    request()->routeIs('role.holidays.index') ||
                    request()->routeIs('role.shifts.index') ||
                    request()->routeIs('role.leaves.index') ||
                    request()->routeIs('role.attendances.index') ||
                    request()->routeIs('role.leave-types.index') ||
                    request()->routeIs('role.attendence-settings.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.departments.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.departments.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-building"></i> Department
                </a>
                <a href="<?php echo e(route('role.designations.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.designations.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-building"></i> Designation
                </a>
                <a href="<?php echo e(route('role.attendence-settings.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.attendence-settings.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> Attendance Settings
                </a>
                <a href="<?php echo e(route('role.shifts.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.shifts.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> Shift
                </a>
                <a href="<?php echo e(route('role.holidays.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.holidays.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> Holidays
                </a>
                <a href="<?php echo e(route('role.leave-types.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.leave-types.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> Leave Types
                </a>
                <a href="<?php echo e(route('role.leaves.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.leaves.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> All Leaves
                </a>
                <a href="<?php echo e(route('role.attendances.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.attendances.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-cog"></i> All Attendances
                </a>
            </div>
        </div>

        <!-- Payroll -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('payrollSubmenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-money-check-alt w-6 text-center mr-1"></i>
                    <span>Payroll</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="payrollSubmenu" class="submenu pl-0 mt-1 space-y-1 text-sm
                <?php echo e(request()->routeIs('role.salary-templates.index') ||
                    request()->routeIs('role.departments.index') ||
                    request()->routeIs('role.salary-templates.index') ||
                    request()->routeIs('role.sales-records.index') ||
                    request()->routeIs('role.employee-salaries.index') ||
                    request()->routeIs('role.loans.index') ||
                    request()->routeIs('role.payments.index') ||
                    request()->routeIs('role.payslips.index') ||
                    request()->routeIs('role.advance-salaries.index') ||
                    request()->routeIs('role.commissions.index') ? '' : 'hidden'); ?>">
                <a href="<?php echo e(route('role.salary-templates.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.salary-templates.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-file-invoice-dollar"></i> Salary Template
                </a>
                
                <a href="<?php echo e(route('role.employee-salaries.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.employee-salaries.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-list"></i> Salary Manage
                </a>
                <a href="<?php echo e(route('role.loans.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.loans.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-hand-holding-dollar"></i> Loan Management
                </a>
                
                <a href="<?php echo e(route('role.payslips.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.payslips.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-file-lines"></i> Payslip
                </a>
                <a href="<?php echo e(route('role.advance-salaries.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.advance-salaries.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-sack-dollar"></i> Advance Salary
                </a>
                <a href="<?php echo e(route('role.commissions.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.commissions.index') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-percent"></i> Commission
                </a>
            </div>
        </div>

        <!-- Bank -->
        <a href="<?php echo e(route('role.banks.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.banks.index') ? 'active' : ''); ?>">
            <i class="fas fa-building-columns w-6 text-center mr-1"></i>
            <span>Bank</span>
        </a>

        <!-- Report -->
        <div class="sidebar-item">
            <button onclick="toggleSubmenu('reportMenu', this)" class="w-full flex justify-between items-center p-3 text-white hover:text-blue-200 focus:outline-none cursor-pointer">
                <div class="flex items-center text-left">
                    <i class="fas fa-book w-6 text-center mr-1"></i>
                    <span>Report</span>
                </div>
                <i class="fas fa-chevron-down text-sm transition-transform duration-300"></i>
            </button>
            <div id="reportMenu" class="submenu pl-0 mt-1 space-y-1 text-sm <?php echo e(request()->routeIs('role.report.monthly-attendances') ? '' : 'hidden'); ?>">                
                <a href="<?php echo e(route('role.report.monthly-attendances', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="submenu-item block p-2 text-blue-100 hover:text-white cursor-pointer <?php echo e(request()->routeIs('role.report.monthly-attendances') ? 'active' : ''); ?>">
                    <i style="margin-right: 5px;" class="fa-solid fa-list"></i> Monthly Attendance
                </a>
            </div>
        </div>

        <!-- Marketing Section -->
        <div class="pt-4 mt-4 border-t border-blue-500/30">
            <h3 class="text-xs uppercase text-blue-300 font-semibold px-3 mb-2">Marketing</h3>

            <!-- Email Marketing -->
            <a href="<?php echo e(route('role.email-marketing.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.email-marketing.index') ? 'active' : ''); ?>">
                <i class="fas fa-envelope w-6 text-center mr-1"></i>
                <span>Email Marketing</span>
            </a>

            <!-- SMS Marketing -->
            <a href="<?php echo e(route('role.sms-marketing.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.sms-marketing.index') ? 'active' : ''); ?>">
                <i class="fas fa-sms w-6 text-center mr-1"></i>
                <span>SMS Marketing</span>
            </a>

            <!-- WhatsApp Marketing -->
            <a href="<?php echo e(route('role.whatsapp-marketing.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.whatsapp-marketing.index') ? 'active' : ''); ?>">
                <i class="fab fa-whatsapp w-6 text-center mr-1"></i>
                <span>WhatsApp Marketing</span>
            </a>
        </div>

        <!-- Settings -->
        <div class="pt-4 mt-4 border-t border-blue-500/30">
            <h3 class="text-xs uppercase text-blue-300 font-semibold px-3 mb-2">Settings</h3>
            <a href="<?php echo e(route('role.sms_templates.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.sms_templates.index') ? 'active' : ''); ?>">
                <i class="fas fa-cog w-6 text-center mr-1"></i>
                <span>SMS Templates</span>
            </a>
            <a href="<?php echo e(route('role.company-settings.index', ['role' => Str::slug(Auth::user()->getRoleNames()->first())])); ?>" class="sidebar-item flex items-center p-3 text-white hover:text-blue-200 cursor-pointer <?php echo e(request()->routeIs('role.company-settings.index') ? 'active' : ''); ?>">
                <i class="fas fa-cog w-6 text-center mr-1"></i>
                <span>Company Settings</span>
            </a>
        </div>

    </nav>
</aside>
<?php /**PATH D:\laragon\www\epal_hrm\resources\views/layout/sidebar.blade.php ENDPATH**/ ?>